import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/manual/parts/signes%20and%20rules%20manual/web_view_of_manual.dart';

class SignesPage extends StatefulWidget {
  final String appBarTitle;
  const SignesPage({Key? key, required this.appBarTitle}) : super(key: key);

  @override
  _SignesPageState createState() => _SignesPageState();
}

class _SignesPageState extends State<SignesPage> {
  late Map<String, String>? paths;
  List<String> imagesPaths = [
    'assets/html/manual/2_Znaki/1xx_Preduprejdaushie/1.1.png',
    'assets/html/manual/2_Znaki/2xx_Prioritet/2.1.png',
    'assets/html/manual/2_Znaki/3xx_Zapreshaushie/3.1.png',
    'assets/html/manual/2_Znaki/4xx_Predpisivaushie/4.1.1.png',
    'assets/html/manual/2_Znaki/5xx_Inform_Ukazatelnie/5.1.png',
    'assets/html/manual/2_Znaki/6xx_Servis/6.1.png',
    'assets/html/manual/2_Znaki/7xx_Dop_Informacia/7.1.1.png',
  ];

  @override
  void initState() {
    if (Config.language == 'ru') {
      paths = {
        "Предупреждающие знаки":
            "2_Znaki/1xx_Preduprejdaushie/Preduprejdaushie.html",
        "Знаки приоритета": "2_Znaki/2xx_Prioritet/Prioritet.html",
        "Запрещающие знаки": "2_Znaki/3xx_Zapreshaushie/Zapreshaushie.html",
        "Предписывающие": "2_Znaki/4xx_Predpisivaushie/Predpisivaushiy.html",
        "Информационно-указательные знаки":
            "2_Znaki/5xx_Inform_Ukazatelnie/inform_Ukazatelnie.htm",
        "Знаки сервиса": "2_Znaki/6xx_Servis/Servis.html",
        "Знаки дополнительной информации":
            "2_Znaki/7xx_Dop_Informacia/dop_informacia.html",
      };
    } else if (Config.language == 'uz') {
      paths = {
        "Огоҳлантирувчи белгилар":
            "2_Znaki/1xx_Preduprejdaushie/Preduprejdaushie_UZ.html",
        "Имтиёз белгилари": "2_Znaki/2xx_Prioritet/Prioritet_UZ.html",
        "Тақиқловчи белгилар":
            "2_Znaki/3xx_Zapreshaushie/Zapreshaushie_UZ.html",
        "Буюрувчи белгилар":
            "2_Znaki/4xx_Predpisivaushie/Predpisivaushiy_UZ.html",
        "Ахборот кўрсатгич белгилари":
            "2_Znaki/5xx_Inform_Ukazatelnie/inform_ukazatelnie_UZ.htm",
        "Сервис белгилари": "2_Znaki/6xx_Servis/Servis_UZ.html",
        "Қўшимча маълумот белгилари":
            "2_Znaki/7xx_Dop_Informacia/dop_informacia_UZ.html",
      };
    } else if (Config.language == 'oz') {
      paths = {
        "Ogohlantiruvchi belgilar":
            "2_Znaki/1xx_Preduprejdaushie/Preduprejdaushie_UZ.html",
        "Imtiyoz belgilari": "2_Znaki/2xx_Prioritet/Prioritet_UZ.html",
        "Taqiqlovchi belgilar":
            "2_Znaki/3xx_Zapreshaushie/Zapreshaushie_UZ.html",
        "Buyuruvchi belgilar":
            "2_Znaki/4xx_Predpisivaushie/Predpisivaushiy_UZ.html",
        "Axborot ko'rsatgich belgilari":
            "2_Znaki/5xx_Inform_Ukazatelnie/inform_ukazatelnie_UZ.htm",
        "Servis belgilari": "2_Znaki/6xx_Servis/Servis_UZ.html",
        "Qo'shimcha ma'lumot belgilari":
            "2_Znaki/7xx_Dop_Informacia/dop_informacia_UZ.html",
      };
    }
    super.initState();
  }

  @override
  void dispose() {
    paths = null;
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.appPrimaryColor,
      appBar: appBar(context),
      body: Container(
        padding: const EdgeInsets.symmetric(horizontal: 16.0),
        child: SingleChildScrollView(
          child: Column(
            children: List.generate(
              paths!.length,
              (index) => Column(
                children: [
                  InkWell(
                    onTap: () {
                      Navigator.push(
                        context,
                        CupertinoPageRoute(
                          builder: (context) => WebViewOfManual(
                            appBarTitle: widget.appBarTitle,
                            pathOfHTML: "${paths!.values.toList()[index]}",
                          ),
                        ),
                      );
                    },
                    child: Container(
                      height: 68.0,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Container(
                            height: 40.0,
                            width: 40.0,
                            padding: const EdgeInsets.all(7.0),
                            margin:
                                const EdgeInsets.symmetric(horizontal: 10.0),
                            decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              color: Color(0xff767680).withOpacity(0.12),
                            ),
                            child: Image.asset(imagesPaths[index]),
                          ),
                          Expanded(
                            child: Text(
                              paths!.keys.toList()[index],
                              maxLines: 2,
                              textAlign: TextAlign.start,
                              overflow: TextOverflow.ellipsis,
                              style: AppStyle.textStyle().copyWith(
                                  color: Color(0xff282828),
                                  fontWeight: FontWeight.w400,
                                  fontSize: 16.0),
                            ),
                          ),
                          const Padding(
                            padding:
                                const EdgeInsets.symmetric(horizontal: 8.0),
                            child: Icon(
                              Icons.chevron_right,
                              color: AppColors.unSelectedColor,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  if (index != paths!.length - 1)
                    const Divider(
                      height: 1.0,
                      color: Color(0XFFCACACA),
                    )
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }

  AppBar appBar(BuildContext context) {
    return AppBar(
      toolbarHeight: 60.0,
      leading: Material(
        type: MaterialType.transparency,
        child: InkWell(
          onTap: () {
            Navigator.pop(context);
          },
          child: Container(
            margin: const EdgeInsets.all(10.0),
            decoration: BoxDecoration(
              color: Color(0xffDFDFDF),
              shape: BoxShape.circle,
            ),
            child: const Center(
              child: Icon(
                Icons.arrow_back_ios_outlined,
                size: 20.0,
                color: Colors.black,
              ),
            ),
          ),
        ),
      ),
      title: Text(
        widget.appBarTitle,
        style: AppStyle.textStyle().copyWith(
            color: Colors.black, fontWeight: FontWeight.w600, fontSize: 21.0),
        maxLines: 2,
        textAlign: TextAlign.center,
      ),
    );
  }
}
